<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:akcwg="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/AKC_WG.xsd" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/AKC_WG.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Trader.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Trader.xsd" version="1.0"><xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/><xsl:output encoding="utf-8" method="html"/><xsl:template match="/"><xsl:apply-templates select="*"/></xsl:template><!-- POCZATEK ALL --><!-- STYL ARKUSZA --><xsl:template match="*" mode="styl1"><style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style><style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style><style type="text/css">a{color:#3366FF;font-weight:bold;}</style><style type="text/css">h3{padding:3px;cursor:help;}</style><style type="text/css">h4,h5,.copyr{text-align:center;}</style><style type="text/css">caption{font-weight:bold;}</style><style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style><style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">#cont{display:none}</style><style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style><style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style><style type="text/css">.nag2{font-size: 20px}</style><style type="text/css">.cz10 {font-size: 10px}</style><style type="text/css">.cz12 {	font-size: 12px}</style><style type="text/css">.cz18 {font-size: 18px}</style><style type="text/css">.cz16 {font-size: 16px}</style><style type="text/css">.cz14 {font-size: 14px}</style></xsl:template><!-- SZABLON STOPKI --><xsl:template match="*" mode="stopka"><xsl:value-of select="name()"/></xsl:template><xsl:template match="*"><!-- ZASTOSOWANIE STYLU --><xsl:apply-templates mode="styl1" select="*"/><!-- DEKLARACJE AKCYZOWE --><xsl:apply-templates mode="dekl_AKCWG" select="."/></xsl:template><!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --><xsl:template match="*" mode="dekl_AKCWG"><xsl:for-each select=" ns1:Header |  ns4:* | akcwg:Header | tr:* "><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:apply-templates mode="Ident" select="."/><!-- SZABLON DLA RODZAJU DEKLARACJI --><xsl:apply-templates mode="rodz_dekl" select="."/><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:apply-templates mode="rok_mc" select="."/><!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --><xsl:apply-templates mode="PodstawaPrawna" select="."/><!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --><xsl:apply-templates mode="MiejsceDekl" select="."/><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:apply-templates mode="DanePodatnika" select="."/><!-- SZABLON DOT. ADRESU PODATNIKA --><xsl:apply-templates mode="Adres" select="."/><!-- SZABLON DOT. WYROBOW --><xsl:apply-templates mode="Wyroby" select="."/><!-- SZABLON DOT. KWOTY PODATKU --><xsl:apply-templates mode="KwotaPodatku" select="."/><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:apply-templates mode="OswPodatnika" select="."/><!-- SZABLON DOT. ADNOTACJI--><xsl:apply-templates mode="Adnotacje" select="."/><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:apply-templates mode="ObjasnieniaAkc" select="."/></xsl:for-each></xsl:template><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:template match="*" mode="Ident"><table border="1" width="955"><tr align="left" valign="top"><td align="left" colspan="2" height="45" valign="middle" width="586"><span class="cz12"><b>1. Identyfikator podatkowy NIP/numer PESEL<sup>(niepotrzebne skreślić)</sup> podatnika<sup>1)</sup></b></span></td><td align="center" colspan="2" valign="middle" width="353"><span class="nag2"><b><xsl:value-of select="@identifier"/></b></span></td></tr><tr align="left" colspan="1" valign="top"><td align="left" height="45" valign="top" width="353"/><td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top"><b>2. Nr dokumentu</b><br/><span class="cz16"><b><xsl:value-of select="@selfRef"/></b></span></td><td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top"><b>3. Status</b></td></tr></table></xsl:template><!-- SZABLON DOT.  RODZAJU DEKLARACJI --><xsl:template match="*" mode="rodz_dekl"><xsl:if test="ns1:* | akcwg:*"><table border="1" width="956"><tr><td colspan="3" height="40"><span class="nag1">AKCWG</span></td></tr><tr><td height="61" width="154"/><td width="537"><div align="center"><span class="nag1">DEKLARACJA DLA PODATKU AKCYZOWEGO OD NABYCIA WEWNĄTRZWSPÓLNOTOWEGO  WYROBÓW GAZOWYCH </span><br/><span class="nag1">(z wyłączeniem gazu do napędu silników spalinowych)</span></div></td><td width="243"/></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:template match="*" mode="rok_mc"><xsl:if test="ns1:* | akcwg:*"><table border="1" width="955"><tr><td height="49" width="247"/><td align="left" valign="top" width="135"><b>4. Miesiąc</b><br/><div align="center" class="cz18"><xsl:value-of select="substring(@period,6,7)"/></div></td><td align="left" valign="top" width="131"><b>5. Rok </b><br/><div align="center" class="cz18"><xsl:value-of select="substring(@period,1,4)"/></div></td><td width="206"/><td align="left" valign="top" width="206"><br/><div align="center" class="cz18"/></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --><xsl:template match="*" mode="PodstawaPrawna"><xsl:if test="ns1:* | akcwg:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td align="left" valign="top" width="115">Podstawa prawna: </td><td align="left" valign="top" width="824">Art. 24b ust. 1 pkt 1 ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2017 r. poz. 43, z późn. zm.). </td></tr><tr bgcolor="#CCCCCC"><td align="left" valign="top">Termin składania:</td><td align="left" valign="top">Do 25. dnia miesiąca następującego po miesiącu, w którym upłynął termin płatności wynikający z faktury, a jeżeli termin ten nie został określony - po miesiącu, w którym wystawiono fakturę.</td></tr><tr bgcolor="#CCCCCC"><td align="left" valign="top">Miejsce składania: </td><td align="left" valign="top">Urząd celny kierowany przez naczelnika właściwego ze względu na miejsce wykonywania czynności lub wystąpienia stanów faktycznych, podlegających opodatkowaniu akcyzą; jeżeli czynności podlegające opodatkowaniu akcyzą są wykonywane lub stany faktyczne podlegające opodatkowaniu akcyzą występują na obszarze właściwości miejscowej dwóch lub więcej naczelników urzędów celnych – zgodnie z art. 14 ust. 4 – 4f ustawy; jeżeli właściwym organem podatkowym jest Naczelnik Urzędu Celnego I w Warszawie, to miejscem składania jest Urząd Celny I w Warszawie. Deklaracja może być złożona w każdym urzędzie celnym lub urzędzie skarbowym, w którym jest prowadzone centrum obsługi. </td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --><xsl:template match="*" mode="MiejsceDekl"><xsl:if test="ns1:* | akcwg:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag1">A. WŁAŚCIWY ORGAN I CEL SKŁADANIA DEKLARACJI</span></td></tr><tr align="left"><td bgcolor="#CCCCCC" rowspan="2" width="40"/><td align="left" rowspan="2" valign="top" width="425"><b>6. Naczelnik urzędu skarbowego</b><br/><br/><span class="cz18"><xsl:value-of select="@taxOffice"/></span></td><td align="left" colspan="2" valign="top"><b>7. Cel złożenia formularza </b>(zaznaczyć właściwy kwadrat):</td></tr><tr><td align="left" valign="top">1. złożenie deklaracji<br/><span class="cz18"><xsl:choose><xsl:when test="//@submissionAim='Deklaracja'"><b>X</b></xsl:when><xsl:otherwise><b/></xsl:otherwise></xsl:choose></span></td><td align="left" valign="top">2. korekta deklaracji<sup style="cz9">2)</sup><br/><span class="cz18"><xsl:choose><xsl:when test="//@submissionAim='Korekta'"><b>X</b><!--	<span class="cz10"> <xsl:value-of select="@justification"/> </span> --></xsl:when><xsl:otherwise><b/></xsl:otherwise></xsl:choose></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:template match="*" mode="DanePodatnika"><xsl:if test="ns1:* | akcwg:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag1">B. DANE PODATNIKA</span><br/> *- dotyczy podmiotów niebędących osobami fizycznymi **- dotyczy podmiotów będących osobami fizycznymi </td></tr><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag2">B.1. DANE IDENTYFIKACYJNE PODATNIKA </span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td align="left" colspan="3" height="27" valign="top"><b>8. Rodzaj podatnika </b>(zaznaczyć właściwy kwadrat): </td></tr><tr><td align="left" valign="top">1. podatnik niebędący osobą fizyczną <br/><span class="cz18"><xsl:choose><xsl:when test=".//ns1:Trader/@typeOfTaxpayer='N'"><b>X</b></xsl:when><xsl:otherwise><b/></xsl:otherwise></xsl:choose></span></td><td align="left" valign="top" width="425">2. osoba fizyczna <br/><span class="cz18"><xsl:choose><xsl:when test=".//ns1:Trader/@typeOfTaxpayer='F'"><b>X</b></xsl:when><xsl:otherwise><b/></xsl:otherwise></xsl:choose></span></td></tr><tr><td align="left" colspan="3" valign="top"><b>9. Nazwa pełna */Nazwisko, pierwsze imię, data urodzenia ** </b><br/><br/><span class="cz18"><xsl:value-of select="//@fullName"/></span><span class="cz18"><xsl:value-of select="//@REGON"/></span><span class="cz18"><xsl:value-of select="//@firstName"/></span><span class="cz18"><xsl:value-of select="//@surname"/></span><span class="cz18"><xsl:value-of select="//@dateOfBirth"/></span><span class="cz18"><xsl:value-of select="//@PESEL"/></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. ADRESU PODATNIKA --><xsl:template match="*" mode="Adres"><xsl:if test="ns1:* | akcwg:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="6"><span class="nag2">B.2. ADRES SIEDZIBY* / ADRES ZAMIESZKANIA ** </span></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td width="269"><b>10. Kraj </b><br/><br/><span class="cz18"><xsl:value-of select=".//@country"/></span></td><td colspan="2"><b>11. Województwo</b><br/><br/><span class="cz18"><xsl:value-of select=".//@provinceName"/></span></td><td colspan="2"><b>12. Powiat</b><br/><br/><span class="cz18"><xsl:value-of select=".//@districtName"/></span></td></tr><tr align="left" valign="top"><td><b>13. Gmina </b><br/><br/><span class="cz18"><xsl:value-of select=".//@communeName"/></span></td><td colspan="2"><b>14. Ulica</b><br/><br/><span class="cz18"><xsl:value-of select=".//@street"/></span></td><td width="144"><b>15. Nr domu</b><br/><br/><span class="cz18"><xsl:value-of select=".//@houseNumber"/></span></td><td width="151"><b>16. Nr lokalu</b><br/><br/><span class="cz18"><xsl:value-of select=".//@localNumber"/></span></td></tr><tr align="left" valign="top"><td><b>17. Miejscowość</b><br/><br/><span class="cz18"><xsl:value-of select=".//@city"/></span></td><td colspan="2"><b>18. Kod pocztowy</b><br/><br/><span class="cz18"><xsl:value-of select=".//@postalCode"/></span></td><td colspan="2"><b>19. Poczta <sup>(pole nieobowiązkowe)</sup></b><br/><br/><span class="cz18"><xsl:value-of select=".//@postalName"/></span></td></tr></table><table width="955"><tr><td><sup>1)</sup>numer PESEL należy podać w przypadku podatników będących osobami fizycznymi objętymi rejestrem PESEL nieprowadzących działalności gospodarczej lub niebędących zarejestrowanymi podatnikami podatku od towarów i usług <br/><sup>2</sup>Zgodnie z art.81 ustawy z dnia 29 sierpnia 1997 r. - Ordynacja podatkowa (Dz. U. z 2017 r.poz.201, z późn. zm.).</td></tr></table><table width="955"><tr align="right" valign="top"><td colspan="3"><span class="nag1">AKCWG</span><sub style="cz9">(4)</sub><b style="nag1">/1</b></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. WYROBOW --><xsl:template match="ns1:* | akcwg:*" mode="Wyroby"><!-- ZNAK KONCA STRONY DO WYDRUKU --><div style="page-break-before: always"><!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select=".." mode = "stopka"/></b></span> </td> </tr> </table> --></div><!-- TABELKA DLA J --><table border="1" width="955"><!-- NAGLOWEK --><tr align="left" bgcolor="#CCCCCC" valign="top"><td class="nag1" colspan="7">C. OBLICZENIE KWOT PODATKU AKCYZOWEGO OD WYROBÓW</td></tr><!-- I-OPIS --><tr align="center" bgcolor="#CCCCCC" valign="middle"><td width="20"> Lp. </td><td width="301"> Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatkowe </td><td width="100"><p align="center">Ośmiocyfrowy kod CN </p></td><td colspan="2"><p align="center">Ilość wyrobów w tysiącach kilogramów <br/> lub ilość w GJ <sup>3)</sup><br/> (z dokładnością do trzech miejsc po przecinku) </p></td><td width="80">Stawka podatku </td><td width="153"><p align="center">Kwota podatku w zł </p></td></tr><!-- II-WIERSZ - OZNACZENIE --><tr align="center" bgcolor="#CCCCCC" valign="middle"><td><div align="center"><b>a.</b></div></td><td><div align="center"><b>b.</b></div></td><td><div align="center"><b>c.</b></div></td><td><div align="center"><b>d.</b></div></td><td><div align="center"><b>e.</b></div></td><td><div align="center"><b>f.</b></div></td><td><div align="center"><b>g.</b></div></td></tr><!-- III - WARTOSCI --><xsl:for-each select="//ns1:Item | //akcwg:Item"><tr align="left" valign="top"><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@id"/></div></td><td><div align="left" class="cz14" valign="top"><xsl:value-of select="@groupOfGoodsName"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@codeCN"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@numberOfGoodsK"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@numberOfGoodsJ"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@taxRate"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/></div></td></tr></xsl:for-each><!-- PODSUMOWANIE TABELKI --><xsl:for-each select="."><!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> </tr> --><tr><td>-</td><td bgcolor="#CCCCCC"><b>Razem </b></td><td bgcolor="#CCCCCC">-</td><td><b>272.</b><div align="right" class="cz18" valign="top"><b><xsl:value-of select="//@totalNumberOfGoodsK"/></b></div></td><td><b>273.</b><div align="right" class="cz18" valign="top"><b><xsl:value-of select="//@totalNumberOfGoodsJ"/></b></div></td><td bgcolor="#CCCCCC">-</td><td><b>274.</b><div align="right" class="cz18" valign="top"><b><xsl:value-of select="format-number(number(.//@totalAmountOfTax),'# ##0')"/></b></div></td></tr></xsl:for-each></table><!-- STOPKA --><table border="1" width="955"><tr><td><p><sup>3)</sup> Jeżeli stawka podatku akcyzowego została określona w zł/1000 kilogramów, należy wypełnić pola w kolumnie "d", natomiast jeżeli stawka podatku akcyzowego została określona w zł/GJ, należy wypełnić pola w kolumnie "e". </p></td></tr></table><!-- KONIEC TABELKI ZAL_C --></xsl:template><!-- SZABLON DOT. KWOTY PODATKU --><xsl:template match="ns1:Header | akcwg:*" mode="KwotaPodatku"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td class="nag1" colspan="4"><b>D. KWOTA PODATKU AKCYZOWEGO </b></td></tr><tr><td bgcolor="#CCCCCC" rowspan="4" width="40"><p/><p/><p/><p/></td><td align="left" bgcolor="#CCCCCC" height="42" valign="top" width="610"><b>Razem obliczony podatek  </b><br/><p> Kwota z poz. 274</p></td><td align="left" colspan="2" valign="top" width="283"><b>275.</b><br/><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(//@totalAmountOfTax),'# ##0')"/></div><div align="right" class="cz9" valign="bottom">zł</div></td></tr><tr><td align="left" bgcolor="#CCCCCC" height="46" valign="top"><b>Zwolnienia i obniżenia </b><br/><p>Wykazana kwota nie może przekroczyć kwoty z poz. 275</p></td><td align="left" colspan="2" valign="top"><b>276.</b><br/><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(//@reductions),'# ##0')"/></div><div align="right" class="cz9" valign="bottom">zł</div></td></tr><tr><td bgcolor="#CCCCCC"><b>Podatek akcyzowy do zapłaty<sup>***)</sup></b><br/><p>Od kwoty z poz.275 należy odjąć kwotę wykazaną w poz. 276.</p></td><td align="left" colspan="2" valign="top"><b>277.</b><br/><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(//@totalOfTax),'# ##0')"/></div><div align="right" class="cz9" valign="bottom">zł</div></td></tr></table></xsl:template><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:template match="*" mode="OswPodatnika"><xsl:if test="ns1:* | ns3:* | akcwg:* | tp:*"><table border="1" height="210" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="3"><b><span class="nag1">E. PODPIS PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span></b></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td height="37" width="402"><b>278. Imię </b><br/><br/><span class="cz18"><xsl:value-of select="//@repFirstName"/></span></td><td width="491"><b>279. Nazwisko </b><br/><br/><span class="cz18"><xsl:value-of select="//@repSurname"/></span></td></tr><tr align="left" valign="top"><td height="39"><b>280. Data wypełnienia formularza</b>(dzień-miesiąc-rok) <br/><br/><br/><span class="cz18"><xsl:value-of select="substring(//@declarationDate,9,2)"/><xsl:value-of select="substring(//@declarationDate,5,4)"/><xsl:value-of select="substring(//@declarationDate,1,4)"/></span></td><td><b>281.Podpis podatnika lub osoby reprezentującej podatnika </b></td></tr><tr align="left" valign="top"><td colspan="2" height="70"><b>282. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika </b>(pole nieobowiązkowe) <br/><br/><br/><span class="cz18"><xsl:value-of select="//@phone"/>, <xsl:value-of select="//@email"/></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. ADNOTACJI--><xsl:template match="*" mode="Adnotacje"><xsl:if test="ns1:* | akcwg:*"><table border="1" height="167" width="955"><tr bgcolor="#CCCCCC"><td colspan="3" height="36"><span class="nag1">E. ADNOTACJE URZĘDU SKARBOWEGO </span><br/>W przypadku deklaracji złożonej za pomocą środków komunikacji elektronicznej wypełnienie pól: 283, 284 i 285 nie jest obowiązkowe. </td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td rowspan="2" width="40"/><td colspan="2" height="72"><b>283. Uwagi urzędu celnego <br/><br/><br/><br/><br/><br/><br/></b></td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td height="49" width="472"><b>284. Identyfikator przyjmującego formularz <br/><br/><br/></b><p/></td><td width="421"><b>285. Podpis przyjmującego formularz </b></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:template match="*" mode="ObjasnieniaAkc"><xsl:if test="ns1:* | akcwg:*"><table width="955"><tr><td><p align="center"><b>Objaśnienie</b><b/></p><p>Podstawy opodatkowania (wyrażone kwotowo) i kwoty podatków zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa</p><p align="center"><b> Pouczenia </b></p><p>***) W wypadku niewpłacenia w obowiązującym terminie kwoty z poz. 277 lub wpłacenia jej w niepełnej wysokości niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2017 r. poz. 1201, z późn. zm.). <br/> Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym. </p></td></tr><tr align="right" valign="top"><td colspan="3"><span class="nag1">AKC-WG</span><sub style="cz9">(4)</sub><b style="nag1">/2</b></td></tr></table></xsl:if></xsl:template><!-- KONIEC all AG--></xsl:stylesheet>